<link rel="stylesheet" href="<?php echo base_url(); ?>assets/js/jquery-ui/css/smoothness/jquery-ui-1.9.2.custom.css" />
<link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/table-custom.css" />
<script type="text/javascript" src="<?php echo base_url() ?>assets/js/jquery-ui/js/jquery-ui-1.9.2.custom.js"></script>
<script src="<?php echo base_url() ?>assets/js/sweetalert2.all.min.js"></script>

<div class="span12" style="margin-left: 0">
    <form method="get" action="<?php echo base_url(); ?>index.php/os/gerenciar">
        <?php if ($this->permission->checkPermission($this->session->userdata('permissao'), 'aOs')) { ?>
            <div class="span2">
                <a href="<?php echo base_url(); ?>index.php/os/adicionar" class="btn btn-success span12"><i class="fas fa-plus"></i> Adicionar OS</a> 
            </div>
        <?php
        } ?>
		<div class="span1">
            <input type="text" name="pesquisaOs"  id="pesquisaOs" autocomplete="off" placeholder="OS" class="span12" value="" >
        </div>
		<div class="span2">
            <input type="text" name="pesquisa" id="pesquisa" autocomplete="off" placeholder="Nome do cliente" class="span12" value="">
        </div>
		<div class="span2">
            <input type="text" name="pesquisaDesc" id="pesquisaDesc" autocomplete="off" placeholder="Pesquisa Descrição" class="span12" value="">
        </div>
        <div class="span1">
            <input type="text" name="pesquisaSerie" id="pesquisaSerie" autocomplete="off" placeholder="NS/IMEI" class="span12" value="">
        </div>

        <div class="span2">
            <select name="status[]" id="status" class="span12" multiple>
                <option value="">Selecione status</option>
                <option value="Aberto">Aberto</option>
                <option value="Orçamento">Orçamento</option>
                <option value="Faturado">Faturado</option>
                <option value="Entregue">Entregue</option>
                <option value="Orç. Finalizado">Orç.Finalizado</option>
                <option value="Garantia Apple">Garantia Apple</option>
                <option value="Aguardando Peças">Aguardando Peças</option>
                <option value="Enviado Dudu">Enviado Dudu</option>
                <option value="Serviço Autorizado">Autorizado</option>
                <option value="Serviço em Andamento">Em Andamento</option>
				<option value="Sem Reparo">Sem Reparo</option>
                <option value="Serviço Concluido">Concluido</option>
               
            </select>

        </div>

        <div class="span2">
            <input type="text" name="data" autocomplete="off" id="data" placeholder="Data Inicial" class="span6 datepicker" value="">
            <input type="text" name="data2" autocomplete="off" id="data2" placeholder="Data Final" class="span6 datepicker" value="">
        </div>
        <div class="span1">
            <button class="span12 btn"><i class="fas fa-search"></i></button>
        </div>
    </form>
</div>

<div class="widget-box">
    <div class="widget-title">
        <span class="icon">
            <i class="fas fa-diagnoses"></i>
        </span>
        <h5>Ordens de Serviço</h5>
    </div>
    <div class="widget-content nopadding tab-content">
        <div class="table-responsive">
            <table class="table table-bordered ">
                <thead>
                    <tr style="background-color: #99b6ff">
                        <th>N°OS</th>
                        <th>Cliente</th>
                        <th></th>
                        <th>Dispositivo</th>
                        <th>Entrada</th>
                        <th>Saída</th>
                       
                        <th>Total</th>
                        <th>Faturado</th>
                        <th>Status da OS</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php

                    if (!$results) {
                        echo '<tr>
                                    <td colspan="10">Nenhuma OS Cadastrada</td>
                                  </tr>';
                    }
                    $this->load->model('os_model');
                    foreach ($results as $r) {
                        $dataInicial = date(('d/m/Y'), strtotime($r->dataInicial));
                        if ($r->dataFinal != null) {
                            $dataFinal = date(('d/m/Y'), strtotime($r->dataFinal));
                        } else {
                            $dataFinal = "";
                        }

                        if ($this->input->get('pesquisa') !== '' && $r->status === "Faturadoo") {
                            continue;
                        }

                        switch ($r->status) {
                            case 'Aberto':
                                $cor = '#DC143C';
                                break;
                            case 'Em Andamento':
                                $cor = '#436eee';
                                break;
                            case 'Orçamento':
                                $cor = '#363636';
                                break;
                            case 'Orç. Finalizado':
                                $cor = '#FF1493';
                                break;
                            case 'Cancelado':
                                $cor = '#CD0000';
                                break;
                            case 'Entregue':
                                $cor = '#00FF00';
                                break;
                            case 'Faturado':
                                $cor = '#00FF00';
                                break;
							case 'Garantia Apple':
                                $cor = '#9400D3';
                                break;
							case 'Aguardando Peças':
                                $cor = '#D2691E';
                                break;
							case 'Enviado Dudu':
                                $cor = '#696969';
                                break;
							case 'Autorizado':
                                $cor = '#48D1CC';
                                break;
							case 'Concluido':
                                $cor = '#6A5ACD';
                                break;
							case 'Em Andamento':
                                $cor = '#FFBF00';
                                break;
                            case 'Finalizado':
                                $cor = '#436eee';
                                break;
							case 'Sem Reparo':
                                $cor = '#FF0000';
                                break;
                            default:
                                $cor = '#E0E4CC';
                                break;
                        }
                        $vencGarantia = '';

                        if ($r->garantia && is_numeric($r->garantia)) {
                            $vencGarantia = dateInterval($r->dataFinal, $r->garantia);
                        }

                        echo '<tr>';
                        echo '<td>' . $r->idOs . '</td>';
                        echo '<td><a href="' . base_url() . 'index.php/clientes/visualizar/' . $r->idClientes . '">' . $r->nomeCliente . '</a></td>';
				$zapnumber = preg_replace("/[^0-9]/", "", $r->celular_cliente);
                echo '<td nowrap><a class="btn btn-mini btn-success" style="margin-right: 1%" title="Enviar Msg WhatsApp" id="enviarWhatsApp" href="whatsapp://send?phone=55' . $zapnumber . '"><i class="fab fa-whatsapp"></i></i></a>'  . '</td>';		
   

						
                        echo '<td>' . $r->descricaoProduto . '</td>';
                        echo '<td>' . $dataInicial . '</td>';
                        echo '<td>' . $dataFinal . '</td>';
                       
                        echo '<td nowrap>R$ ' . number_format($r->totalProdutos + $r->totalServicos, 2, ',', '.') . '</td>';
                        echo '<td  nowrap>R$ ' . number_format($r->valorTotal, 2, ',', '.') . '</td>';
                        echo '<td><span class="badge" style="background-color: ' . $cor . '; border-color: ' . $cor . '">' . $r->status . '</span> </td>';
                        
                        echo '<td nowrap>';

                        $editavel = $this->os_model->isEditable($r->idOs);
						

                        if ($this->permission->checkPermission($this->session->userdata('permissao'), 'vOs')) {
							
                            echo '<a style="margin-right: 1%" href="' . base_url() . 'index.php/os/visualizar/' . $r->idOs . '" class="btn tip-top" title="Ver mais detalhes"><i class="fas fa-eye"></i></a>';			
                      
						 echo '<a style="margin-right: 1%" href="' . base_url() . 'index.php/os/imprimir/' . $r->idOs . '" target="_blank" class="btn btn-inverse tip-top" title="Imprimir Normal A4"><i class="fas fa-print"></i></a>';
                            }
						
                        if ($editavel) {
                            echo '<a style="margin-right: 1%" href="' . base_url() . 'index.php/os/editar/' . $r->idOs . '" class="btn btn-info tip-top" title="Editar OS"><i class="fas fa-edit"></i></a>';
                        }
						
                        if ($this->permission->checkPermission($this->session->userdata('permissao'), 'dOs') && $editavel) {
                            echo '<a href="#modal-excluir" role="button" data-toggle="modal" os="' . $r->idOs . '" class="btn btn-danger tip-top" title="Excluir OS"><i class="fas fa-trash-alt"></i></a>  ';
                        }
                        echo '</td>';
                        echo '</tr>';
                    } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php echo $this->pagination->create_links(); ?>

<!-- Modal -->
<div id="modal-excluir" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">

    <form action="<?php echo base_url() ?>index.php/os/excluir" method="post">
        <div class="modal-header">
      
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            <h5 id="myModalLabel">Excluir OS</h5>
        </div>
        <div class="modal-body">
            <input type="hidden" id="idOs" name="id" value="" />
            <h5 style="text-align: center">Deseja realmente excluir esta OS?</h5>
        </div>
        <div class="modal-footer">
            <button class="btn" data-dismiss="modal" aria-hidden="true">Cancelar</button>
            <button class="btn btn-danger">Excluir</button>
        </div>
    </form>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $(document).on('click', 'a', function(event) {
            var os = $(this).attr('os');
            $('#idOs').val(os);
        });
        $(document).on('click', '#excluir-notificacao', function(event) {
            event.preventDefault();
            $.ajax({
                    url: '<?php echo site_url() ?>/os/excluir_notificacao',
                    type: 'GET',
                    dataType: 'json',
                })
                .done(function(data) {
                    if (data.result == true) {
                        Swal.fire({
                            type: "success",
                            title: "Sucesso",
                            text: "Notificação excluída com sucesso."
                        });
                        location.reload();
                    } else {
                        Swal.fire({
                            type: "success",
                            title: "Sucesso",
                            text: "Ocorreu um problema ao tentar exlcuir notificação."
                        });
                    }
                });
        });
        $(".datepicker").datepicker({
            dateFormat: 'dd/mm/yy'
        });
    });
</script>
