<?php if ($this->permission->checkPermission($this->session->userdata('permissao'), 'aFuncionario')) { ?>
    <a href="<?php echo base_url(); ?>index.php/funcionarios/adicionar" class="btn btn-success"><i class="fas fa-plus"></i> Adicionar Funcionario</a>
<?php } ?>

<div class="widget-box">
    <div class="widget-title">
        <span class="icon">
            <i class="fas fa-headphones"></i>
        </span>
        <h5>Funcionários</h5>
    </div>

    <div class="widget-content nopadding tab-content">
        <table id="tabela" class="table table-bordered ">
            <thead>
                <tr>
                    <th>Cod.</th>
                    <th>Nome</th>
                    <th>CPF</th>
                    <th>Telefone</th>
					<th>Celular</th>
                    <th>Email</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php

                    if (!$results) {
                        echo '<tr>
                                <td colspan="5">Nenhum Funcionario Cadastrado</td>
                                </tr>';
                    }
                    foreach ($results as $r) {
                        echo '<tr>';
                        echo '<td>' . $r->idFuncionarios . '</td>';
                        echo '<td><a href="' . base_url() . 'index.php/funcionarios/visualizar/' . $r->idFuncionarios . '" style="margin-right: 1%">' .strtoupper($r->nomeFuncionario) . '</a></td>';
                        echo '<td>' . $r->cpf . '</td>';
                        echo '<td>' . $r->telefone . '</td>';
						echo '<td>' . $r->celular . '</td>';
                        echo '<td>' . $r->email . '</td>';
                        echo '<td>';
                        if ($this->permission->checkPermission($this->session->userdata('permissao'), 'vFuncionario')) {
                            //echo '<a href="' . base_url() . 'index.php/funcionarios/visualizar/' . $r->idFuncionarios . '" style="margin-right: 1%" class="btn tip-top" title="Ver mais detalhes"><i class="fas fa-eye"></i></a>';
                            //echo '<a href="' . base_url() . 'index.php/mine?e=' . $r->email . '&c=' . $r->senha . '" target="new" style="margin-right: 1%" class="btn tip-top" title="Área do funcionario"><i class="fas fa-key"></i></a>';
                        }
                        if ($this->permission->checkPermission($this->session->userdata('permissao'), 'eFuncionario')) {
                            echo '<a href="' . base_url() . 'index.php/funcionarios/editar/' . $r->idFuncionarios . '" style="margin-right: 1%" class="btn btn-info tip-top" title="Editar Funcionario"><i class="fas fa-edit"></i></a>';
                        }
                        if ($this->permission->checkPermission($this->session->userdata('permissao'), 'dFuncionario')) {
                            echo '<a href="#modal-excluir" role="button" data-toggle="modal" funcionario="' . $r->idFuncionarios . '" style="margin-right: 1%" class="btn btn-danger tip-top" title="Excluir Funcionario"><i class="fas fa-trash-alt"></i></a>';
                        }
                        echo '</td>';
                        echo '</tr>';
                    } ?>

            </tbody>
        </table>
    </div>
</div>
<?php echo $this->pagination->create_links(); ?>


<!-- Modal -->
<div id="modal-excluir" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <form action="<?php echo base_url() ?>index.php/funcionarios/excluir" method="post">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            <h5 id="myModalLabel">Excluir Funcionario</h5>
        </div>
        <div class="modal-body">
            <input type="hidden" id="idFuncionario" name="id" value="" />
            <h5 style="text-align: center">Deseja realmente excluir este funcionario?</h5>
        </div>
        <div class="modal-footer">
            <button class="btn" data-dismiss="modal" aria-hidden="true">Cancelar</button>
            <button class="btn btn-danger">Excluir</button>
        </div>
    </form>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $(document).on('click', 'a', function(event) {
            var funcionario = $(this).attr('funcionario');
            $('#idFuncionario').val(funcionario);
        });
    });
</script>
