<?php
class Compras_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }

    
    function get($table,$fields,$where='',$perpage=0,$start=0,$one=false,$array='array'){
        
        $this->db->select($fields);
        $this->db->from($table);
        $this->db->order_by('idCompras','desc');
        $this->db->limit($perpage,$start);
		//$this->db->where('faturado =','1');
        if($where){
            $this->db->where($where);
        }
        
        $query = $this->db->get();
        
        $result =  !$one  ? $query->result() : $query->row();
        return $result;
    }

    function getById($id){
        $this->db->where('idCompras',$id);
        $this->db->limit(1);
        return $this->db->get('compras')->row();
    }
    
    function add($table,$data,$returnId = false){
        $this->db->insert($table, $data);         
        if ($this->db->affected_rows() == '1')
		{
			if($returnId == true){
                            return $this->db->insert_id($table);
                        }
			return TRUE;
		}
		
		return FALSE;       
    }
	
	function getCompras() {
        $this->db->order_by('idCompras', 'desc');
        $query = $this->db->get('compras');
        return $query->result();
    }
	
	
	 public function search($pesquisa){
        
        if($pesquisa != null){
			$this->db->group_start();
            $this->db->like('solicitante',$pesquisa);
			$this->db->or_like('idCompras',$pesquisa);
			$this->db->or_like('idOs',$pesquisa);
			$this->db->or_like('fornecedor',$pesquisa);
			$this->db->or_like('comprador',$pesquisa);
			$this->db->or_like('descricao',$pesquisa);
			$this->db->or_like('rastreio',$pesquisa);
			$this->db->or_like('valor',$pesquisa);
			$this->db->group_end();
        }

        $this->db->limit(10000);
        return $this->db->get('compras')->result();
    }
	
    
    function edit($table,$data,$fieldID,$ID){
        $this->db->where($fieldID,$ID);
        $this->db->update($table, $data);

        if ($this->db->affected_rows() >= 0)
		{
			return TRUE;
		}
		
		return FALSE;       
    }
    
    function delete($table,$fieldID,$ID){
        $this->db->where($fieldID,$ID);
        $this->db->delete($table);
        if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
		
		return FALSE;        
    }   
	
	function count($table){
		return $this->db->count_all($table);
	}
}