<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Funcionarios extends MY_Controller
{

    /**
     * author: Ramon Silva
     * email: silva018-mg@yahoo.com.br
     *
     */

    public function __construct()
    {
        parent::__construct();

        $this->load->model('funcionarios_model');
        $this->data['menuFuncionarios'] = 'funcionarios';
		$this->data['menuCadastros'] = 'Cadastros';
    }

    public function index()
    {
        $this->gerenciar();
    }

    public function gerenciar()
    {
        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vFuncionario')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar funcionarios.');
            redirect(base_url());
        }
        $this->load->library('pagination');

        $this->data['configuration']['base_url'] = site_url('funcionarios/gerenciar/');
        $this->data['configuration']['total_rows'] = $this->funcionarios_model->count('funcionarios');

        $this->pagination->initialize($this->data['configuration']);

        $this->data['results'] = $this->funcionarios_model->get('funcionarios', '*', '', $this->data['configuration']['per_page'], $this->uri->segment(3));

        $this->data['view'] = 'funcionarios/funcionarios';
        return $this->layout();
    }

    public function adicionar()
    {
        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'aFuncionario')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para adicionar funcionarios.');
            redirect(base_url());
        }

        $this->load->library('form_validation');
        $this->data['custom_error'] = '';

        if ($this->form_validation->run('funcionarios') == false) {
            $this->data['custom_error'] = (validation_errors() ? '<div class="form_error">' . validation_errors() . '</div>' : false);
        } else {
			
			$dataNascimento = $this->input->post('dataNascimento');
			$dataAdmitido = $this->input->post('dataAdmitido');
			$dataDemitido = $this->input->post('dataDemitido');
            

            if($dataNascimento != null){
                $dataNascimento = explode('/', $dataNascimento);
                $dataNascimento = $dataNascimento[2].'-'.$dataNascimento[1].'-'.$dataNascimento[0];
            } else {
                $dataNascimento = date('Y/m/d');
            }
			
            $data = [
                'nomeFuncionario' => strtoupper(set_value('nomeFuncionario')),
                'contato' => set_value('contato'),
				'cpf' => set_value('cpf'),
				'rg' => set_value('rg'),
				'cnh' => set_value('cnh'),
				'dataNascimento' => $dataNascimento,
				'naturalidade' => set_value('naturalidade'),
				'carteiraTrabalho' => set_value('carteiraTrabalho'),
				'estadoNascimento' => set_value('estadoNascimento'),
				'nacionalidade' => set_value('nacionalidade'),
				'cargo' => set_value('cargo'),
				'salario' => set_value('salario'),
				'dataAdmitido' => $dataAdmitido,
				'dataDemitido' => $dataDemitido,
                'ultimoEmprego' => set_value('ultimoEmprego'),
				'ultimoSalario' => set_value('ultimoSalario'),
                'telefone' => set_value('telefone'),
                'celular' => set_value('celular'),
                'email' => set_value('email'),
                'rua' => set_value('rua'),
                'numero' => set_value('numero'),
                'complemento' => set_value('complemento'),
                'bairro' => set_value('bairro'),
                'cidade' => set_value('cidade'),
                'estado' => set_value('estado'),
                'cep' => set_value('cep'),
                'dataCadastro' => date('Y-m-d'),
                'fornecedor' => (set_value('fornecedor') == true ? 1 : 0),
            ];

            if ($this->funcionarios_model->add('funcionarios', $data) == true) {
                $this->session->set_flashdata('success', 'Funcionario adicionado com sucesso!');
                log_info('Adicionou um funcionario.');
                redirect(site_url('funcionarios/adicionar/'));
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro.</p></div>';
            }
        }

        $this->data['view'] = 'funcionarios/adicionarFuncionario';
        return $this->layout();
    }

    public function editar()
    {
        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'eFuncionario')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para editar funcionarios.');
            redirect(base_url());
        }

        $this->load->library('form_validation');
        $this->data['custom_error'] = '';

        if ($this->form_validation->run('funcionarios') == false) {
            $this->data['custom_error'] = (validation_errors() ? '<div class="form_error">' . validation_errors() . '</div>' : false);
        } else {
			
            $dataNascimento = $this->input->post('dataNascimento');
			$dataAdmitido = $this->input->post('dataAdmitido');
			$dataDemitido = $this->input->post('dataDemitido');

            try {
                
                $dataNascimento = explode('/', $dataNascimento);
                $dataNascimento = $dataNascimento[2].'-'.$dataNascimento[1].'-'.$dataNascimento[0];
				
				$dataAdmitido = explode('/', $dataAdmitido);
                $dataAdmitido = $dataAdmitido[2].'-'.$dataAdmitido[1].'-'.$dataAdmitido[0];
				
				$dataDemitido = explode('/', $dataDemitido);
                $dataDemitido = $dataDemitido[2].'-'.$dataDemitido[1].'-'.$dataDemitido[0];

                
            } catch (Exception $e) {
               $dataNascimento = date('Y/m/d'); 
			   $dataAdmitido = date('Y/m/d'); 
			   $dataDemitido = date('Y/m/d'); 
            }
            $data = [
                'nomeFuncionario' => strtoupper($this->input->post('nomeFuncionario')),
                'contato' => $this->input->post('contato'),
                'cpf' => $this->input->post('cpf'),
				'rg' => $this->input->post('rg'),
				'cnh' => $this->input->post('cnh'),
				'dataNascimento' => $dataNascimento,
				'naturalidade' => $this->input->post('naturalidade'),
				'carteiraTrabalho' => $this->input->post('carteiraTrabalho'),
				'estadoNascimento' => $this->input->post('estadoNascimento'),
				'nacionalidade' => $this->input->post('nacionalidade'),
				'cargo' => $this->input->post('cargo'),
				'salario' => $this->input->post('salario'),
				'dataAdmitido' => $dataAdmitido,
				'dataDemitido' => $dataDemitido,
				'ultimoEmprego' => $this->input->post('ultimoEmprego'),
				'ultimoSalario' => $this->input->post('ultimoSalario'),
				'telefone' => $this->input->post('telefone'),
                'celular' => $this->input->post('celular'),
                'email' => $this->input->post('email'),
                'rua' => $this->input->post('rua'),
                'numero' => $this->input->post('numero'),
                'complemento' => $this->input->post('complemento'),
                'bairro' => $this->input->post('bairro'),
                'cidade' => $this->input->post('cidade'),
                'estado' => $this->input->post('estado'),
                'cep' => $this->input->post('cep'),
                'fornecedor' => (set_value('fornecedor') == true ? 1 : 0),
            ];

            if ($this->funcionarios_model->edit('funcionarios', $data, 'idFuncionarios', $this->input->post('idFuncionarios')) == true) {
                $this->session->set_flashdata('success', 'Funcionario editado com sucesso!');
                log_info('Alterou um funcionario. ID' . $this->input->post('idFuncionarios'));
                redirect(site_url('funcionarios/editar/') . $this->input->post('idFuncionarios'));
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro...</p></div>';
            }
        }

        $this->data['result'] = $this->funcionarios_model->getById($this->uri->segment(3));
        $this->data['view'] = 'funcionarios/editarFuncionario';
        return $this->layout();
    }

    public function visualizar()
    {
        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vFuncionario')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar funcionarios.');
            redirect(base_url());
        }

        $this->data['custom_error'] = '';
        $this->data['result'] = $this->funcionarios_model->getById($this->uri->segment(3));
        $this->data['results'] = $this->funcionarios_model->getOsByCliente($this->uri->segment(3));
		$this->data['transacoes'] = $this->funcionarios_model->getLancamentosByCliente($this->uri->segment(3));
		$this->data['resultvendas'] = $this->funcionarios_model->getVendasByCliente($this->uri->segment(3));
        $this->data['view'] = 'funcionarios/visualizar';
        return $this->layout();
    }

    public function excluir()
    {
        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'dFuncionario')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para excluir funcionarios.');
            redirect(base_url());
        }

        $id = $this->input->post('id');
        if ($id == null) {
            $this->session->set_flashdata('error', 'Erro ao tentar excluir funcionario.');
            redirect(site_url('funcionarios/gerenciar/'));
        }

       // $os = $this->funcionarios_model->getAllOsByClient($id);
        if ($os != null) {
            $this->funcionarios_model->removeClientOs($os);
        }

        // excluindo Vendas vinculadas ao funcionario
        //$vendas = $this->funcionarios_model->getAllVendasByClient($id);
        if ($vendas != null) {
            $this->funcionarios_model->removeClientVendas($vendas);
        }

        $this->funcionarios_model->delete('funcionarios', 'idFuncionarios', $id);
        log_info('Removeu um funcionario. ID' . $id);

        $this->session->set_flashdata('success', 'Funcionario excluido com sucesso!');
        redirect(site_url('funcionarios/gerenciar/'));
    }
}
