<?php 

class Compras extends MY_Controller {
    

    /**
     * author: Ramon Silva 
     * email: silva018-mg@yahoo.com.br
     * 
     */
    
    function __construct() {
        parent::__construct();
        if( (!session_id()) || (!$this->session->userdata('logado'))){
            redirect('mapos/login');
        }

        $this->load->helper(array('form', 'codegen_helper'));
        $this->load->model('compras_model', '', TRUE);
        $this->data['menuCompras'] = 'Compras';
    }
	
	function index(){
		$this->gerenciar();
	}

	function gerenciar(){
        
        if(!$this->permission->checkPermission($this->session->userdata('permissao'),'vCompra')){
           $this->session->set_flashdata('error','Você não tem permissão para visualizar Compras.');
           redirect(base_url());
        
		$this->data['results'] = $this->compras_model->getCompras();
        $this->data['view'] = 'compras/compras';
        $this->load->view('tema/topo', $this->data);
		}
		
		
		
		$where = '';
		$pesquisa = $this->input->get('pesquisa');
		$this->load->library('table');
		$this->load->library('pagination');
		   if($pesquisa == null ){
		
		//$config['base_url'] = site_url().'/financeiro/?periodo='.$periodo.'&status='.$status;
        //$this->load->library('pagination');

        $this->data['configuration']['base_url'] = site_url("compras/compras/?periodo=$periodo&status=$status");
        $this->data['configuration']['total_rows'] = $this->compras_model->count('compras', $where);
        $this->data['configuration']['page_query_string'] = true;

        
        //$this->load->library('pagination');
        
        
            $this->data['configuration']['base_url'] = site_url('produtos/gerenciar/');
        $this->data['configuration']['total_rows'] = $this->compras_model->count('produtos');

        $this->pagination->initialize($this->data['configuration']);

		$this->data['results'] = $this->compras_model->get('compras','idCompras,idOs,OSbloco,solicitante,comprador,fornecedor,descricao,qtde,valor,dataPedido,dataPrevista,rastreio','',$this->data['configuration']['per_page'],$this->uri->segment(3));
       
	   }
        else{

            if($de != null){

                $de = explode('/', $de);
                $de = $de[2].'-'.$de[1].'-'.$de[0];

                if($ate != null){
                    $ate = explode('/', $ate);
                    $ate = $ate[2].'-'.$ate[1].'-'.$ate[0]; 
                }
                else{
                    $ate = $de;
                }
            }

            $this->data['results'] = $this->compras_model->search($pesquisa, $de, $ate);
        }
		

	    $this->data['view'] = 'compras/compras';
       	//$this->load->view('tema/topo',$this->data);
		 return $this->layout();
       
		
    }
	
    function adicionar() {
        if(!$this->permission->checkPermission($this->session->userdata('permissao'),'aCompra')){
           $this->session->set_flashdata('error','Você não tem permissão para adicionar compras.');
           redirect(base_url());
        }

        $this->load->library('form_validation');
        $this->data['custom_error'] = '';

        if ($this->form_validation->run('compras') == false) {
            $this->data['custom_error'] = (validation_errors() ? '<div class="form_error">' . validation_errors() . '</div>' : false);
        } else {
            $valor = $this->input->post('valor');
            $valor = str_replace(",","", $valor);
            //$faturado = '0';

            $dataPedido = $this->input->post('dataPedido');
            $dataPrevista = $this->input->post('dataPrevista');

            if($dataPedido != null){
                $dataPedido = explode('/', $dataPedido);
                $dataPedido = $dataPedido[2].'-'.$dataPedido[1].'-'.$dataPedido[0];
            } else {
                $dataPedido = date('Y/m/d');
            }

            if($dataPrevista != null){
                $dataPrevista = explode('/', $dataPrevista);
                $dataPrevista = $dataPrevista[2].'-'.$dataPrevista[1].'-'.$dataPrevista[0];
            } else {
                $dataPrevista = date('Y/m/d');
            }

            $data = array(
                'idOs' => $this->input->post('idOs'),
				'OSbloco' => $this->input->post('OSbloco'),
                'solicitante' => $this->input->post('solicitante'),
                'comprador' => $this->input->post('comprador'),
                'fornecedor' => $this->input->post('fornecedor'),
                'descricao' => $this->input->post('descricao'),
				'qtde' => $this->input->post('qtde'),
                'valor' => $valor,
                'dataPedido' => $dataPedido,
                'dataPrevista' => $dataPrevista,
                'rastreio' => $this->input->post('rastreio'),
                'status' => $this->input->post('status'),
                //'faturado' => $faturado
				'faturado' => 0
            );

            if ($this->compras_model->add('compras', $data) == TRUE) {
                $this->session->set_flashdata('success', 'Compra adicionada com sucesso!');
				log_info('Adicionou uma compra');
                redirect(base_url() . 'index.php/compras/adicionar/');
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro.</p></div>';
            }
        }
        $this->data['view'] = 'compras/adicionarCompra'; 
         return $this->layout();

    }

    function editar() {
        if(!$this->permission->checkPermission($this->session->userdata('permissao'),'eCompra')){
           $this->session->set_flashdata('error','Você não tem permissão para editar compras.');
           redirect(base_url());
        }
        $this->load->library('form_validation');
        $this->data['custom_error'] = '';

        if ($this->form_validation->run('compras') == false) {
            $this->data['custom_error'] = (validation_errors() ? '<div class="form_error">' . validation_errors() . '</div>' : false);
        } else {
            $valor = $this->input->post('valor');
            $valor = str_replace(",","", $valor);
            $faturado = $this->input->post('faturado');
			//$faturado = '1';
            $dataPedido = $this->input->post('dataPedido');
            $dataPrevista = $this->input->post('dataPrevista');

            try {
                
                $dataPedido = explode('/', $dataPedido);
                $dataPedido = $dataPedido[2].'-'.$dataPedido[1].'-'.$dataPedido[0];

                $dataPrevista = explode('/', $dataPrevista);
                $dataPrevista = $dataPrevista[2].'-'.$dataPrevista[1].'-'.$dataPrevista[0];

            } catch (Exception $e) {
               $dataPedido = date('Y/m/d'); 
            }

            $data = array(
                'idOs' => $this->input->post('idOs'),
				'OSbloco' => $this->input->post('OSbloco'),
                'solicitante' => $this->input->post('solicitante'),
                'comprador' => $this->input->post('comprador'),
                'fornecedor' => $this->input->post('fornecedor'),
                'descricao' => $this->input->post('descricao'),
				'qtde' => $this->input->post('qtde'),
                'valor' => $valor,
                'dataPedido' => $dataPedido,
                'dataPrevista' => $dataPrevista,
                'rastreio' => $this->input->post('rastreio'),
                'status' => $this->input->post('status'),
                'faturado' => $this->input->post('faturado'), 
				'faturado' => 1
            );

            if ($this->compras_model->edit('compras', $data, 'idCompras', $this->input->post('idCompras')) == TRUE) {
                $this->session->set_flashdata('success', 'Compra editada com sucesso!');
				log_info('Editou uma compra');
                redirect(base_url() . 'index.php/compras/editar/'.$this->input->post('idCompras'));
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro.</p></div>';
            }
        }

        $this->data['result'] = $this->compras_model->getById($this->uri->segment(3));

        $this->data['view'] = 'compras/editarCompra';
        return $this->layout();

    }
	
    function excluir(){

        if(!$this->permission->checkPermission($this->session->userdata('permissao'),'dCompra')){
           $this->session->set_flashdata('error','Você não tem permissão para excluir compras.');
           redirect(base_url());
        }
       
        
        $id =  $this->input->post('id');
        if ($id == null){

            $this->session->set_flashdata('error','Erro ao tentar excluir compra.');            
            redirect(base_url().'index.php/compras/gerenciar/');
        }

        $this->db->where('compra_id', $id);
        $this->db->delete('compras_os');

        $this->compras_model->delete('compras','idCompras',$id);             
        

        $this->session->set_flashdata('success','Compra excluida com sucesso!');     
		log_info('Excluiu uma compra');
        redirect(base_url().'index.php/compras/gerenciar/');
    }

    public function faturar() {

        $this->load->library('form_validation');
        $this->data['custom_error'] = '';

        if ($this->form_validation->run('comprasDespesa') == false) {
            $this->data['custom_error'] = (validation_errors() ? '<div class="form_error">' . validation_errors() . '</div>' : false);
        } else {

            $vencimento = $this->input->post('pedido');
            $pagamento = $this->input->post('pagamento');
			$pcontas = $this->input->post('pcontas');
            $categoria = $this->input->post('categoria');
            try {
				
                $vencimento = explode('/', $vencimento);
                $vencimento = $vencimento[2].'-'.$vencimento[1].'-'.$vencimento[0];
				
				if($pagamento != null){
                $pagamento = explode('/', $pagamento);
                $pagamento = $pagamento[2].'-'.$pagamento[1].'-'.$pagamento[0];
            }

            } catch (Exception $e) {
               $vencimento = date('Y/m/d'); 
            }
            
            $data = array(
                'descricao' => set_value('descricaoFaturar'),
                'valor' => $this->input->post('valorFaturar'),
                'data_pagamento' => $vencimento, // as datas estão invertidas
                'data_vencimento' => $pagamento != null ? $pagamento : date('Y-m-d'),
                'baixado' => $this->input->post('pago') ? : 0,
                'cliente_fornecedor' => set_value('fornecedorFaturar'),
				'pcontas' => set_value('pcontas'),
				'categoria' => set_value('categoria'),
                'forma_pgto' => $this->input->post('formaPgto'),
                'tipo' => $this->input->post('tipo')
            );

            if ($this->compras_model->add('lancamentos',$data) == TRUE) { 
                
                $os = $this->input->post('idCompras'); 

                $this->db->set('faturado',1);
				$this->db->set('status', 'Faturado');
                $this->db->set('valor',$this->input->post('valorFaturar'));
				$this->db->where('idCompras', $os);
                $this->db->update('compras'); 
				log_info('Faturou uma compra ' . $os);
                $this->session->set_flashdata('success','Compra faturada com sucesso! / Agora Altere o status para Faturado e Salve.');
				$json = array('result'=>  true);
                echo json_encode($json);
                die();
            } else {
                $this->session->set_flashdata('error','Ocorreu um erro ao tentar faturar a Compra 1.');
                $json = array('result'=>  false);
                echo json_encode($json);
                die();
            }
        }

        $this->session->set_flashdata('error','Ocorreu um erro ao tentar faturar a Compra 2.');
        $json = array('result'=>  false);
        echo json_encode($json);
        
    }
}

